<?php $__env->startSection('content'); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Update Product</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Product</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">

                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">Update Product</h3>
                        </div>
                        <form method="POST" action="<?php echo e(route('product.update', [$product->id])); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-md col-sm mb-2">
                                        <label for="product_no">Product No</label>
                                        <input type="text" class="form-control" name="product_no" value="<?php echo e($product->product_no); ?>" placeholder="Product No" required>
                                    </div>
                                    <div class="col-md col-sm mb-2">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control" name="name" value="<?php echo e($product->name); ?>" placeholder="Name" required>
                                    </div>
                                    <div class="col-md col-sm mb-2">
                                        <label for="price">Price</label>
                                        <input type="number" class="form-control" name="price" value="<?php echo e($product->price); ?>" placeholder="Price" step="0.01" min="0">
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md col-sm mb-2">
                                        <label for="remarks">Remarks</label>
                                        <input type="text" class="form-control" name="remarks" value="<?php echo e($product->remarks); ?>" placeholder="Write Something ...">
                                    </div>
                                    <div class="col-md col-sm mb-2">
                                        <label for="status">Status</label>
                                        <select name="status" class="form-control">
                                            <option disabled <?php echo e(empty($product->status) ? 'selected' : ''); ?>>--Select One--</option>
                                            <option value="active" <?php echo e($product->status == 'active' ? 'selected' : ''); ?>>Active</option>
                                            <option value="inactive" <?php echo e($product->status == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                        </select>
                                    </div>
                                    <div class="col-md col-sm mb-2">
                                    </div>
                                </div>
                                <div class="form-check">
                                    <input
                                        class="form-check-input"
                                        name="checked"
                                        value="1"
                                        id="remarksCheckbox"
                                        type="checkbox"
                                        <?php echo e($product->checked == 1 ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="remarksCheckbox">Checkbox</label>
                                    <span style="color: gray;">(optional)</span>
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<aside class="control-sidebar control-sidebar-dark">
</aside>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/muhammadajmal/Documents/www/nes/resources/views/product/edit.blade.php ENDPATH**/ ?>