<?php $__env->startPush('css'); ?>

<style>
    /* Print-specific styles */
    @media  print {
        .print-right {
            float: right;
            text-align: right;
            width: 100%;
            position: relative;
            top: -55px;
        }

        .row {
            display: flex;
            flex-direction: row;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Invoice</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Invoice</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Main content -->
                    <div class="invoice p-3 mb-3">
                        <!-- title row -->
                        <div class="row">
                            <div class="col-12">
                                <h4>
                                    <i class="fas fa-globe"></i> NEC Portal. Order ID: #00<?php echo e($order->id); ?>

                                    <small class="float-right">Date: <?php echo e($order->created_at->format('d-m-Y')); ?></small>
                                </h4>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- info row -->
                        <div class="row invoice-info mb-3">
                            <div class="col-sm-4 invoice-col mb-3">
                                <b>Company Name:</b> <?php echo e($order->company->name ?? 'N/A'); ?><br>
                                <b>Mechanic Name:</b> <?php echo e($order->mechanic->name ?? 'N/A'); ?><br>
                                <b>Order Status:</b> <?php echo e($order->status); ?><br>
                                <b>Delivery Date:</b> <?php echo e($order->delivery_date); ?><br>
                            </div>
                            <!-- /.col -->
                            <div class="col-sm-4 invoice-col mb-3">
                                <b>Vehicle Details:</b><br>
                                <b>Vehicle Name:</b> <?php echo e($order->vehicle_name); ?><br>
                                <b>Vehicle No:</b> <?php echo e($order->vehicle_no); ?><br>
                            </div>
                            <!-- /.col -->
                            <div class="col-sm-4 invoice-col">
                                <b>Client Details </b><br>
                                <b>Client Name:</b> <?php echo e($order->client_name); ?><br>
                                <b>Client Phone:</b> <?php echo e($order->client_phone); ?><br>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->

                        <h3>Products Detail:</h3>
                        <!-- Table row -->
                        <div class="row">
                            <div class="col-12 table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Product No</th>
                                            <th>Name</th>
                                            <th>Quantity #</th>
                                            <th>Remarks</th>
                                            <th>Price</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($product->id); ?></td>
                                            <td><?php echo e($product->product_no); ?></td>
                                            <td><?php echo e($product->name); ?></td>
                                            <td><?php echo e($product->pivot->qty); ?></td>
                                            <td><?php echo e($product->pivot->remarks); ?></td>
                                            <td><?php echo e($product->pivot->price); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                            <!-- /.col -->
                        </div>

                        <h3>Services Detail:</h3>
                        <!-- Table row -->
                        <div class="row">
                            <div class="col-12 table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Quantity #</th>
                                            <th>Remarks</th>
                                            <th>Price</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $order->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($service->id); ?></td>
                                            <td><?php echo e($service->name); ?></td>
                                            <td><?php echo e($service->pivot->qty); ?></td>
                                            <td><?php echo e($service->pivot->remarks); ?></td>
                                            <td><?php echo e($service->pivot->price); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <h3 class="mb-4">Order Images:</h3>
                        <div class="row g-1 mb-4">
                            <?php $__currentLoopData = explode(',', $order->car_picture); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-2">
                                <div class="gallery-item gray">
                                    <a href="<?php echo e(asset('images/car_pictures/' . $image)); ?>?text=1"
                                        data-toggle="lightbox"
                                        data-title="<?php echo e($order->date); ?>"
                                        data-gallery="gallery">
                                        <img src="<?php echo e(asset('images/car_pictures/' . $image)); ?>?text=1"
                                            class="img-fluid rounded"
                                            alt="<?php echo e($order->date); ?>"
                                            style="width: 100px; height: 100px; object-fit: cover;" />
                                    </a>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>


                        <div class="row">
                            <!-- Mobile View: Total Price at the top -->
                            <div class="col-12 d-sm-none mb-3">
                                <p class="lead text-center"><b>Total Price:</b> <span><?php echo e($order->total_price); ?></span></p>
                            </div>

                            <!-- Main Content -->
                            <div class="col-md-8 col-sm-12">
                                <p class="lead"><b>Order By:</b> <span><?php echo e(auth()->user()->name); ?></span></p>
                                <p class="lead"><b>Order Note:</b> <span><?php echo e($order->notes); ?></span></p>

                                <!-- Mobile View: Signature and Received By stacked -->
                                <div class="d-sm-none">
                                    <p class="lead mt-3"><b>Signature:</b> <span>________________________</span></p>
                                    <p class="lead mt-3"><b>Received By:</b> <span>________________________</span></p>
                                    <p class="lead mt-3"><b>Authorized By:</b> <span>________________________</span></p>
                                </div>
                            </div>

                            <!-- Right Side Content -->
                            <div class="col-md-4 col-sm-12">
                                <!-- Desktop & Print View -->
                                <div class="d-none d-sm-block">
                                    <p class="lead"><b>Total Price:</b> <span class="float-md-right"><?php echo e($order->total_price); ?></span></p>
                                    <p class="lead mt-3"><b>Received By:</b> <span class="float-md-right">________________________</span></p>
                                    <p class="lead mt-3 print-right"><b>Authorized By:</b> <span class="float-md-right">________________________</span></p>
                                </div>
                            </div>
                        </div>




                        <div class="row no-print">
                            <div class="col-12">
                                <button class="btn btn-primary float-right" onclick="window.print()">
                                    <i class="fas fa-print"></i> Print
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<aside class="control-sidebar control-sidebar-dark">
</aside>
</div>

<?php $__env->startPush('js'); ?>

<script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
<!-- <script src="../../plugins/jquery/jquery.min.js"></script> -->
<script src="<?php echo e(asset('plugins/ekko-lightbox/ekko-lightbox.min.js')); ?>"></script>


<script>
    $(function() {
        $(document).on('click', '[data-toggle="lightbox"]', function(event) {
            event.preventDefault();
            $(this).ekkoLightbox({
                alwaysShowClose: true
            });
        });

        $('.filter-container').filterizr({
            gutterPixels: 3
        });
        $('.btn[data-filter]').on('click', function() {
            $('.btn[data-filter]').removeClass('active');
            $(this).addClass('active');
        });
    })
</script>

<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/muhammadajmal/Documents/www/nes/resources/views/order/view.blade.php ENDPATH**/ ?>