<?php $__env->startSection('content'); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Update Service</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Service</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md col-sm">

                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">Update Service</h3>
                        </div>
                        <form method="POST" action="<?php echo e(route('service.update', [$service->id])); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-md col-sm mb-2">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control" name="name" value="<?php echo e($service->name); ?>" placeholder="Name" required>
                                    </div>
                                    <div class="col-md col-sm mb-2">
                                        <label for="price">Price</label>
                                        <input type="number" class="form-control" name="price" value="<?php echo e($service->price); ?>" placeholder="Price" step="0.01" min="0">
                                    </div>
                                    <div class="col-md col-sm mb-2">
                                        <label for="status">Status</label>
                                        <select name="status" class="form-control">
                                            <option disabled <?php echo e(empty($service->status) ? 'selected' : ''); ?>>--Select One--</option>
                                            <option value="active" <?php echo e($service->status == 'active' ? 'selected' : ''); ?>>Active</option>
                                            <option value="inactive" <?php echo e($service->status == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md col-sm mb-2">
                                        <label for="remarks">Remarks</label>
                                        <input type="text" class="form-control" name="remarks" value="<?php echo e($service->remarks); ?>" placeholder="Write Something ...">
                                    </div>
                                    <div class="col-md col-sm mb-2">

                                    </div>
                                    <div class="col-md col-sm mb-2">
                                    </div>
                                </div>
                                <div class="form-check">
                                    <input
                                        class="form-check-input"
                                        name="checked"
                                        value="1"
                                        id="remarksCheckbox"
                                        type="checkbox"
                                        <?php echo e($service->checked == 1 ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="remarksCheckbox">Checkbox</label>
                                    <span style="color: gray;">(optional)</span>
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<aside class="control-sidebar control-sidebar-dark">
</aside>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/muhammadajmal/Documents/www/nes/resources/views/service/edit.blade.php ENDPATH**/ ?>